/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.custom.center.api.enums.kuwo;

import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.Map;

public enum KuwoConsumerChanceSourceEnum {
    SOURCE_PLAY_SONG(1, "\u64ad\u653e\u6b4c\u66f2"),
    SOURCE_FAVOR_SONG(2, "\u6536\u85cf\u6b4c\u66f2"),
    SOURCE_SHARE(3, "\u5206\u4eab"),
    SOURCE_SEND_SONG(4, "\u6295\u626d\u86cb"),
    SOURCE_SIGN(5, "\u7b7e\u5230"),
    SOURCE_NEW_VISIT(10, "\u65b0\u7528\u6237\u9996\u6b21\u8bbf\u95ee"),
    SOURCE_OLD_VISIT(11, "\u65e7\u7528\u6237\u9996\u6b21\u8bbf\u95ee");

    private static final int DEFAULT_ADD_TIMES = 1;
    private static final int NEW_VISIT_ADD_TIMES = 2;
    private static final int VISIT_EXPIRE_ADD_DAYS = 1;
    private static final int NOT_EXPIRE_ADD_YEARS = 10;
    private static final ZoneId DEFAULT_ZONE_ID;
    private Integer source;
    private String desc;
    private static Map<Integer, KuwoConsumerChanceSourceEnum> enumMap;

    private KuwoConsumerChanceSourceEnum(Integer source, String desc) {
        this.source = source;
        this.desc = desc;
    }

    public static KuwoConsumerChanceSourceEnum getBySource(Integer source) {
        return enumMap.get(source);
    }

    public int getTaskBit() {
        if (this.isVisitSource()) {
            return 1;
        }
        return 1 << this.source;
    }

    public int getAddTimes() {
        if (this == SOURCE_NEW_VISIT) {
            return 2;
        }
        return 1;
    }

    public Date getExpireTime() {
        if (this.isVisitSource()) {
            return Date.from(LocalDate.now().plusDays(1L).atStartOfDay(DEFAULT_ZONE_ID).toInstant());
        }
        return Date.from(LocalDate.now().plusYears(10L).atStartOfDay(DEFAULT_ZONE_ID).toInstant());
    }

    public boolean isVisitSource() {
        return this == SOURCE_NEW_VISIT || this == SOURCE_OLD_VISIT;
    }

    public Integer getSource() {
        return this.source;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        DEFAULT_ZONE_ID = ZoneId.systemDefault();
        enumMap = Maps.newHashMap();
        enumMap.put(SOURCE_PLAY_SONG.getSource(), SOURCE_PLAY_SONG);
        enumMap.put(SOURCE_FAVOR_SONG.getSource(), SOURCE_FAVOR_SONG);
        enumMap.put(SOURCE_SHARE.getSource(), SOURCE_SHARE);
        enumMap.put(SOURCE_SIGN.getSource(), SOURCE_SIGN);
    }
}

