package cn.com.duiba.activity.custom.center.api.remoteservice.happyclear;

import cn.com.duiba.activity.custom.center.api.dto.happyclear.HappyClearScratchCardTaskDto;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author: zhengjianhao
 * @date: 2019/10/28 11:56
 * @description: 苏宁消消乐-刮刮卡
 */
@AdvancedFeignClient
public interface RemoteHappyScratchCardTaskService {

	/**
	 * 新增刮刮卡任务
	 */
	HappyClearScratchCardTaskDto createTaskCheck(Long activityId, Long appId, Long consumerId) throws BizException;

	/**
	 * 查询最近的刮刮卡任务
	 */
	List<HappyClearScratchCardTaskDto> selectLastTasksByCount(Long activityId, Long consumerId, int count);

	/**
	 * 更新刮刮卡任务状态
	 */
	int updateStatus(Long id, Integer oldStatus, Integer newStatus);

	/**
	 * 更新刮刮卡领奖结果
	 */
	int updateDrawAwardResult(Long id, Integer status, String orderNum, String mainOrderNum, String errorMessage);

	/**
	 * 根据id查询
	 */
	HappyClearScratchCardTaskDto selectById(Long id);
}
