package cn.com.duiba.activity.custom.center.api.remoteservice.boc;

import cn.com.duiba.activity.custom.center.api.dto.boc.UserWhiteListDto;
import cn.com.duiba.activity.custom.center.api.params.boc.HxbankQueryDto;
import cn.com.duiba.activity.custom.center.api.params.boc.UserWhiteListParam;
import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.Date;
import java.util.List;

/**
 * @author xujing
 * @date 2020/3/12
 */
@AdvancedFeignClient
public interface RemoteUserWhiteListService {
    /**
     * 根据条件判断是否在白名单之内
     *
     * @param appId    应用id
     * @param relType  类型
     * @param relValue 值
     * @return
     */
    Boolean isInWhiteList(Long appId, Integer relType, String relValue);

    /**
     * 批量入库
     *
     * @param userWhiteListParam
     * @return
     */
    Integer batchInsert(UserWhiteListParam userWhiteListParam);


    /**
     * 批量删除
     *
     * @param userWhiteListParam
     * @return
     */
    Integer batchDelete(UserWhiteListParam userWhiteListParam);


    /**
     * 获取所有未逻辑删除的白名单
     *
     * @return 白名单列表
     */
    List<UserWhiteListDto> findAllNonDelete(HxbankQueryDto hxbankQueryDto);

    /**
     * 批量更新
     *
     * @param whiteLists 白名单
     * @return 影响行数
     */
    Integer batchUpdate(List<UserWhiteListDto> whiteLists);


    /**
     * 批量插入
     *
     * @param whiteLists 白名单
     * @return 影响行数
     */
    Integer batchInsertToDataBase(List<UserWhiteListDto> whiteLists);

    /**
     * 是否存在白名单
     *
     * @param appId
     * @param relType
     * @param relValue
     * @return
     */
    UserWhiteListDto existInWhiteList(Long appId, Integer relType, String relValue);

    /**
     * 白名单列表
     * @param hxbankQueryDto
     * @return
     */
    Page<UserWhiteListDto> whiteListPage(HxbankQueryDto hxbankQueryDto);

    Integer countWhiteListPage(HxbankQueryDto hxbankQueryDto);

    /**
     * 删除过期的白名单
     * @param appId appId
     * @return 删除行数
     */
    Integer deleteAllExpired(Long appId);

    /**
     * 测试用
     * @param date
     * @param appId
     * @return
     */
    Integer change2TargetMonthForTest(Date date, Long appId);
}
