package cn.com.duiba.activity.custom.center.api.params.happyclear;

import cn.com.duiba.api.bo.page.PageQuery;

import java.io.Serializable;

/**
 * @Description: 苏宁消消乐-奖励发放请求提交记录查询参数类
 * @Author: fxr
 * @Date: 2019/10/23
 */
public class HappyClearAwardQueryParam extends PageQuery implements Serializable {
    private static final long serialVersionUID = 2732123826831721645L;

    /**
     * 提交成功
     */
    public static final int SUBMIT_SUCCESS = 1;

    /**
     * 提交失败
     */
    public static final int SUBMIT_FAIL = 0;

    /**
     * 用户id
     */
    private Long consumerId;

    /**
     * 入库活动id
     */
    private Long operatingActivityId;

    /**
     * 兑吧活动id
     */
    private Long duibaActivityId;

    /**
     * 活动类型
     *
     * @see cn.com.duiba.api.enums.ActivityUniformityTypeEnum#code
     */
    private Integer activityType;

    /**
     * 开发者商品id
     */
    private Long appItemId;

    /**
     * 兑吧商品id
     */
    private Long itemId;

    /**
     * 业务类型
     *
     * @see cn.com.duiba.activity.custom.center.api.enums.happyclear.HappyClearAwardBizTypeEnum#code
     */
    private Integer bizType;

    /**
     * 奖品类型
     *
     * @see cn.com.duiba.activity.common.center.api.enums.happyclear.HappyClearTypeEnum#code
     */
    private Integer optionType;

    /**
     * 提交状态 0:成功 1:失败
     *
     * @see HappyClearAwardQueryParam#SUBMIT_SUCCESS
     * @see HappyClearAwardQueryParam#SUBMIT_FAIL
     */
    private Boolean submitStatus;

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Long getOperatingActivityId() {
        return operatingActivityId;
    }

    public void setOperatingActivityId(Long operatingActivityId) {
        this.operatingActivityId = operatingActivityId;
    }

    public Long getDuibaActivityId() {
        return duibaActivityId;
    }

    public void setDuibaActivityId(Long duibaActivityId) {
        this.duibaActivityId = duibaActivityId;
    }

    public Integer getActivityType() {
        return activityType;
    }

    public void setActivityType(Integer activityType) {
        this.activityType = activityType;
    }

    public Long getAppItemId() {
        return appItemId;
    }

    public void setAppItemId(Long appItemId) {
        this.appItemId = appItemId;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Integer getBizType() {
        return bizType;
    }

    public void setBizType(Integer bizType) {
        this.bizType = bizType;
    }

    public Boolean getSubmitStatus() {
        return submitStatus;
    }

    public void setSubmitStatus(Boolean submitStatus) {
        this.submitStatus = submitStatus;
    }

    public Integer getOptionType() {
        return optionType;
    }

    public void setOptionType(Integer optionType) {
        this.optionType = optionType;
    }
}

