package cn.com.duiba.activity.custom.center.api.remoteservice.ccb;

import cn.com.duiba.activity.custom.center.api.dto.ccb.AiShengHuoTimesCheckDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.Date;

/**
 * 浙江建行-20200127-i生活 不止剁手活动处理
 *
 * @author haojiahong
 * @date 2020-07-02
 */
@AdvancedFeignClient
public interface RemoteCcbAiShengHuoService {

    /**
     * 校验兑换次数
     *
     * @param consumerId
     * @param appItemId
     * @param orderCreateTime 下单时间
     * @return
     */
    AiShengHuoTimesCheckDto timesCheck(Long consumerId, Long appItemId, Date orderCreateTime);

    /**
     * 校验并增加兑换次数
     *
     * @param consumerId
     * @param appItemId
     * @param orderCreateTime 下单时间
     * @return
     */
    AiShengHuoTimesCheckDto checkAndAddTimes(Long consumerId, Long appItemId, Date orderCreateTime);

    /**
     * 回滚兑换次数
     *
     * @param consumerId
     * @param orderCreateTime 下单时间
     * @return
     */
    Boolean rollbackTimes(Long consumerId, Date orderCreateTime);

}
