package cn.com.duiba.activity.custom.center.api.remoteservice.eral;

import cn.com.duiba.activity.custom.center.api.dto.eral.EralImgDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author zyj
 * @date 2019/2/18
 */
@AdvancedFeignClient
public interface RemoteEralImgService {

    /**
     * 通过cids批量查询
     * @param cids
     * @return
     */
    List<EralImgDto> selectByCids(List<Long> cids);

    /**
     * 根据cid查询
     * @param cid
     * @return
     */
    EralImgDto selectByCid(Long cid);

    /**
     * 删除
     * @param cid
     */
    void delete(Long cid);

    /**
     * 更新图片
     * @param eralImgDto
     * @return
     */
    Integer update(EralImgDto eralImgDto);

    /**
     * 新增
     * @param eralImgDto
     * @return
     */
    void insert(EralImgDto eralImgDto);

    /**
     * 点赞数加1
     * @param consumerId
     * @return
     */
    void increLikeNum(Long consumerId);
}
