package cn.com.duiba.activity.custom.center.api.remoteservice.fulu;

import cn.com.duiba.activity.custom.center.api.dto.fulu.VirtualSupplierProcessingOrderLogDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

@AdvancedFeignClient
public interface RemoteVirtualSupplierProcessOrderService {
    /**
     * 根据appId，orderId删除记录
     *
     * @param appId
     * @param orderId
     */
    void deleteByAppIdOrderId(Long appId, Long orderId);

    /**
     * 删除记录
     *
     * @param id
     */
    void deleteById(Long id);

    List<VirtualSupplierProcessingOrderLogDto> findByAppOrderId(Long appId, Long orderId);
}
