package cn.com.duiba.activity.custom.center.api.remoteservice.qingdao;

import cn.com.duiba.activity.custom.center.api.dto.qingdao.QueryManyUserTaskFinishDto;
import cn.com.duiba.activity.custom.center.api.dto.qingdao.QueryTaskFinishDto;
import cn.com.duiba.activity.custom.center.api.dto.qingdao.QueryTaskFinishParam;
import cn.com.duiba.activity.custom.center.api.dto.qingdao.UserFinishDto;
import cn.com.duiba.activity.custom.center.api.dto.qingdao.UserFinishTaskDto;
import cn.com.duiba.activity.custom.center.api.dto.qingdao.UserReceiveCreditDto;
import cn.com.duiba.activity.custom.center.api.paramquery.qingdao.UserReceiveCreditsQueryParam;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @Author: fss
 * @Date: 2021/11/30 17
 * @Description:
 */
@AdvancedFeignClient
public interface RemoteUserReceiveCreditService {

    Long save(UserReceiveCreditDto userReceiveCreditDto);

    Integer updateById(UserReceiveCreditDto userReceiveCreditDto);

    UserReceiveCreditDto getById(Long id);

    /**
     * 用户待领取积分列表
     *
     * @param userReceiveCreditDto
     * @return
     */
    List<UserReceiveCreditDto> queryWaitReceiveList(UserReceiveCreditDto userReceiveCreditDto);

    /**
     * 统计时间段内完成任务数
     * 目前用于统计当月完成基础任务次数
     *
     * @param queryParam
     * @return
     */
    List<UserFinishTaskDto> queryMonthBasicTaskList(UserReceiveCreditsQueryParam queryParam);

    /**
     * 用户待领取积分总值
     *
     * @param userReceiveCreditDto
     * @return
     */
    Long queryWaitReceiveCredits(UserReceiveCreditDto userReceiveCreditDto);

    /**
     * 用户维度批量更新为已领取
     *
     * @param userReceiveCreditDtoList
     * @return
     */
    Integer batchUpdateStatus(List<UserReceiveCreditDto> userReceiveCreditDtoList);

    /**
     * 批量查询用户任务已完成的次数（基础、高级过期时间不同，自行区分）
     *
     * @param queryTaskFinishDto
     * @return
     */
    List<UserFinishTaskDto> batchQueryUserTasksFinishNum(QueryTaskFinishDto queryTaskFinishDto);


    /**
     * 批量多用户单任务查询
     *
     * @param queryTaskFinishDto
     * @return
     */
    List<UserFinishTaskDto> batchManyUserTaskFinishNum(QueryManyUserTaskFinishDto queryTaskFinishDto);

    /**
     * 批量查询用户任务完成次数（多个过期时间）
     * @param queryTaskFinishParam
     * @return
     */
    List<UserFinishTaskDto> batchQueryUserTasksFinishNumRange(QueryTaskFinishParam queryTaskFinishParam);

    /**
     * 根据旧的uid将记录更新至新uid上
     * @param appId
     * @param oldPartnerUid
     * @param partnerUid
     * @return
     */
    Integer updateUidRecordByOldUid(Long appId, String oldPartnerUid, String partnerUid);

    /**
     * 批量插入多条待领取积分
     *
     * @param userReceiveCreditDtoList
     * @param processKey               redis缓存数据的args
     * @return
     */
    Integer batchInsert(List<UserReceiveCreditDto> userReceiveCreditDtoList, String processKey);

    /**
     * 批量插入
     * @param userReceiveCreditDtoList
     * @return
     */
    Integer batchInsertWithoutCache(List<UserReceiveCreditDto> userReceiveCreditDtoList);

    /**
     * 根据参数查询总数
     * @param userReceiveCreditDto
     * @return
     */
    Long countByParams(UserReceiveCreditDto userReceiveCreditDto);

    /**
     * 批量插入多条用户数据
     *
     * @param userReceiveCreditDtoList
     * @return
     */
    Integer batchInsertDetail(List<UserReceiveCreditDto> userReceiveCreditDtoList);

    /**
     * 查询任务列表完成的累计次数
     * @param queryTaskFinishDto
     * @return
     */
    List<UserFinishTaskDto> queryTaskFinishTotalList(QueryTaskFinishDto queryTaskFinishDto);

    /**
     * 查询用户累计、当天的完成次数
     * @param queryParam
     * @return
     */
    UserFinishDto queryUserTaskFinishNum(UserReceiveCreditsQueryParam queryParam);

    /**
     * 【平安普惠】用户任务的所有记录
     *
     * @param appId         应用id
     * @param taskId        任务id
     * @param partnerUserId 用户id
     * @return 记录
     */
    List<UserReceiveCreditDto> puhuiTaskFinishRecord(Long appId, String taskId, String partnerUserId);
}
