package cn.com.duiba.activity.custom.center.api.enums.hsbc;

/**
 * @author fss
 */
public enum HsbcWithdrawTypeEnum {
    DAY(1, "每日"),
    FOREVER(2, "永久"),
    ;

    Integer type;
    String desc;

    HsbcWithdrawTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static HsbcWithdrawTypeEnum valueOfType(Integer type) {
        for (HsbcWithdrawTypeEnum obj : HsbcWithdrawTypeEnum.values()) {
            if (java.util.Objects.equals(obj.type, type)) {
                return obj;
            }
        }
        return null;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
