package cn.com.duiba.activity.custom.center.api.enums.questionnaire;

import java.util.Objects;

/**
 * @author haojiahong
 * @date 2020-05-27
 */
public enum QuestionnaireTypeEnum {
    CREDITS_MALL( 1, "积分商城"),
    ACTIVITY(2, "活动"),
    ;

    private Integer type;
    private String typeName;

    QuestionnaireTypeEnum(Integer type, String typeName) {
        this.type = type;
        this.typeName = typeName;
    }

    public Integer getType() {
        return type;
    }

    public String getTypeName() {
        return typeName;
    }

    public static QuestionnaireTypeEnum getByType(Integer type) {
        for (QuestionnaireTypeEnum value : QuestionnaireTypeEnum.values()) {
            if (Objects.equals(type, value.getType())) {
                return value;
            }
        }
        return null;
    }
}
