package cn.com.duiba.activity.custom.center.api.remoteservice.ccb;

import cn.com.duiba.activity.custom.center.api.dto.ccb.ExchangeLimitCheckResultDto;
import cn.com.duiba.activity.custom.center.api.dto.ccb.ExchangeLimitConfigDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.Date;

/**
 * 建行相关兑换限制
 * Created by 歪大哥😁 on 2019-10-16.
 */
@AdvancedFeignClient
public interface RemoteCcbExchangeLimitService {

    // 当前手机号今日是否还可以兑换 上线为10次
    boolean canExchangeToday(String phone);

    // 回滚当前手机号今日的兑换次数
    boolean rollBackExchangeCountToday(String phone);

    /** 通过hbase实现的通用计数器 变更后数值 返回null表示变更失败 */
    Long hBaseCounterIncr(String itemCode, Long delta);

    /** 查询通过hbase实现的通用计数器当前数值  若不存在则返回0 */
    Long getCountValue(String itemCode);


    ExchangeLimitConfigDto getConfigByActivityId(Long activityId);

    ExchangeLimitConfigDto getConfigByAppItemId(Long appItemId);

    /**
     * 多维度（不支持永久，永久请使用cms后台设置）检查商品兑换次数
     *
     * @param configDto
     * @param cid
     * @param date
     * @return
     */
    ExchangeLimitCheckResultDto check(ExchangeLimitConfigDto configDto, Long cid, Date date);

    /**
     * 增加次数，超出限制
     * @param appItemId
     * @param cid
     * @return true-配置不存在 or 未超出限制,false-超出限制，需要调用decrease进行回滚
     */
    boolean increase(Long appItemId, Long cid);

    boolean decrease(Long appItemId, Long cid, Date date);

}
