package cn.com.duiba.activity.custom.center.api.remoteservice.icbc;

import cn.com.duiba.activity.custom.center.api.dto.icbc.IcbcUserCardDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author fja
 */
@AdvancedFeignClient
public interface RemoteIcbcUserCardService {

    /**
     * 用户所有绑定的银行卡
     *
     * @param consumerId 用户id
     * @return
     */
    List<IcbcUserCardDto> findUserBindCards(Long consumerId);

    /**
     * 设为默认卡
     *
     * @param id         主键
     * @param consumerId 用户id
     * @return
     */
    boolean makeCardDefault(Long id, Long consumerId);

    /**
     * 绑定卡片
     *
     * @param icbcUserCardDto dto
     * @return 主键
     * @throws Exception -
     */
    Long bindCard(IcbcUserCardDto icbcUserCardDto) throws Exception;

    /**
     * 解绑卡片
     *
     * @param id         主键
     * @param consumerId 用户id
     * @throws Exception -
     */
    void unbindCard(Long id, Long consumerId) throws Exception;


    /**
     * 主键查找银行卡
     * @param id 主键
     * @return 银行卡
     */
    IcbcUserCardDto findUserCardById(Long id);
}
