package cn.com.duiba.activity.custom.center.api.remoteservice.zylife;

import cn.com.duiba.activity.custom.center.api.dto.zylife.AdvertConfigDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @Author: fss
 * @Date: 2021/10/13 10
 * @Description:
 */
@AdvancedFeignClient
public interface RemoteAdvertConfigService {

    /**
     * 获取app配置的广告信息
     *
     * @param appId
     * @return
     */
    List<AdvertConfigDto> getAdvertListByAppId(Long appId);

    /**
     * 保存
     *
     * @param entityList
     * @return
     */
    int batchInsert(List<AdvertConfigDto> entityList);

    /**
     * 批量删除
     *
     * @param ids
     * @return
     */
    int deleteBatchByIds(List<Long> ids);

    /**
     * 批量更新
     *
     * @param entityList
     * @return
     */
    int batchUpdate(List<AdvertConfigDto> entityList);
}
