/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.custom.center.api.enums.citic;

import cn.com.duiba.boot.exception.BizException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum MonthTypeEnum {
    NEXT_MONTH(1, 1, "\u4e0b\u4e2a\u6708"),
    CURRENT_MONTH(2, 0, "\u5f53\u6708"),
    LAST_MONTH(3, -1, "\u4e0a\u4e2a\u6708"),
    LAST_TWO_MONTH(4, -2, "\u4e0a2\u4e2a\u6708"),
    LAST_THREE_MONTH(5, -3, "\u4e0a3\u4e2a\u6708"),
    LAST_FOUR_MONTH(6, -4, "\u4e0a4\u4e2a\u6708"),
    LAST_FIVE_MONTH(7, -5, "\u4e0a5\u4e2a\u6708"),
    LAST_SIX_MONTH(8, -6, "\u4e0a6\u4e2a\u6708"),
    LAST_SEVEN_MONTH(9, -7, "\u4e0a7\u4e2a\u6708"),
    LAST_EIGHT_MONTH(10, -8, "\u4e0a8\u4e2a\u6708"),
    LAST_NINE_MONTH(11, -9, "\u4e0a9\u4e2a\u6708"),
    LAST_TEN_MONTH(12, -10, "\u4e0a10\u4e2a\u6708"),
    LAST_ELEVEN_MONTH(13, -11, "\u4e0a11\u4e2a\u6708"),
    LAST_TWELVE_MONTH(14, -12, "\u4e0a12\u4e2a\u6708");

    private Integer type;
    private Integer amount;
    private String desc;
    private static final Map<Integer, MonthTypeEnum> ENUM_MAP;
    private static final Logger LOGGER;

    private MonthTypeEnum(Integer type, Integer amount, String desc) {
        this.type = type;
        this.amount = amount;
        this.desc = desc;
    }

    public Integer getAmount() {
        return this.amount;
    }

    public Integer getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    public static int getBelongMonth(int monthType) throws BizException {
        SimpleDateFormat MONTH_NUMBER = new SimpleDateFormat("yyyyMM");
        MonthTypeEnum typeEnum = MonthTypeEnum.getByCode(monthType);
        if (typeEnum == null) {
            throw new BizException("\u672a\u77e5\u6708\u4efd\u7c7b\u578b");
        }
        int amount = typeEnum.getAmount();
        Date date = new Date();
        Calendar rightNow = Calendar.getInstance();
        rightNow.setTime(date);
        rightNow.add(2, amount);
        date = rightNow.getTime();
        Integer belongMonth = Integer.valueOf(MONTH_NUMBER.format(date));
        LOGGER.info("monthType:{},belongMonth:{},now:{}", new Object[]{monthType, belongMonth, System.currentTimeMillis()});
        return belongMonth;
    }

    public static MonthTypeEnum getByCode(Integer code) {
        return ENUM_MAP.get(code);
    }

    static {
        ENUM_MAP = new HashMap<Integer, MonthTypeEnum>();
        LOGGER = LoggerFactory.getLogger(MonthTypeEnum.class);
        for (MonthTypeEnum tmp : MonthTypeEnum.values()) {
            ENUM_MAP.put(tmp.getType(), tmp);
        }
    }
}

