package cn.com.duiba.activity.custom.center.api.remoteservice.suzhoubank;

import cn.com.duiba.activity.custom.center.api.dto.suzhoubank.SuzhouBankPraiseListDto;
import cn.com.duiba.activity.custom.center.api.dto.suzhoubank.SuzhouBankSecKillConfigDto;
import cn.com.duiba.activity.custom.center.api.enums.suzhoubank.SuzhouBankSaveConfigResultEnum;
import cn.com.duiba.activity.custom.center.api.params.suzhoubank.SuzhouBankSaveConfigRequest;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * 苏州银行打call榜单服务
 * Created by HePeng on 2019/06/04 10:33.
 */
@AdvancedFeignClient
public interface RemoteSuzhouBankSecKillService {
    /**
     * 保存相关配置
     * @param request
     * @return
     */
    SuzhouBankSaveConfigResultEnum saveConfig(SuzhouBankSaveConfigRequest request);

    /**
     * 获取相关配置
     * @param appId
     * @return
     */
    SuzhouBankSecKillConfigDto getConfig(Long appId);

    /**
     * 榜单生效
     * @param id 榜单 ID
     * @return
     */
    Boolean enableList(Long id);

    /**
     * 获取已启用的榜单
     * @param appId
     * @return
     */
    List<SuzhouBankPraiseListDto> getAllListByAppId(Long appId);
}
