package cn.com.duiba.activity.custom.center.api.dto.cmbbank;

import java.io.Serializable;
import java.util.Date;

/**
 * 体验金收益信息表
 */
public class ExperienceCashIncomeInfoDto implements Serializable {

    private static final long serialVersionUID = 4590231728972943205L;
    /**
     * 主键ID
     */
    private Long id;

    /**
     * 活动ID
     */
    private Long activityId;

    /**
     * 用户ID
     */
    private Long consumerId;

    /**
     * 被邀请用户ID
     */
    private Long helpConsumerId;

    /**
     * 金额(分)
     */
    private Long cashAmount;

    /**
     * 状态：0-正常（默认），1-已提现
     *
     * @see cn.com.duiba.activity.custom.center.api.enums.cmbbank.InterestStatusEnum
     */
    private Integer interestStatus;

    /**
     * 利息可提现时间
     */
    private Date interestOutTime;

    /**
     * 利息金额（分）
     */
    private Long interestAmount;

    /**
     * 最近一次收取时间
     */
    private String collectRecentlyDay;

    /**
     * 银行业务流水号
     */
    private String bizNo;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    private String cashDescription;

    public String getCashDescription() {
        return cashDescription;
    }

    public void setCashDescription(String cashDescription) {
        this.cashDescription = cashDescription;
    }

    public String getCollectRecentlyDay() {
        return collectRecentlyDay;
    }

    public void setCollectRecentlyDay(String collectRecentlyDay) {
        this.collectRecentlyDay = collectRecentlyDay;
    }

    public String getBizNo() {
        return bizNo;
    }

    public void setBizNo(String bizNo) {
        this.bizNo = bizNo;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setHelpConsumerId(Long helpConsumerId) {
        this.helpConsumerId = helpConsumerId;
    }

    public Long getHelpConsumerId() {
        return helpConsumerId;
    }

    public void setCashAmount(Long cashAmount) {
        this.cashAmount = cashAmount;
    }

    public Long getCashAmount() {
        return cashAmount;
    }

    public void setInterestStatus(Integer interestStatus) {
        this.interestStatus = interestStatus;
    }

    public Integer getInterestStatus() {
        return interestStatus;
    }

    public void setInterestOutTime(Date interestOutTime) {
        this.interestOutTime = interestOutTime;
    }

    public Date getInterestOutTime() {
        return interestOutTime;
    }

    public void setInterestAmount(Long interestAmount) {
        this.interestAmount = interestAmount;
    }

    public Long getInterestAmount() {
        return interestAmount;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

}

