package cn.com.duiba.activity.custom.center.api.remoteservice.cmbbank;

import cn.com.duiba.activity.custom.center.api.dto.PageResultDto;
import cn.com.duiba.activity.custom.center.api.dto.cmbbank.ExperienceCashIncomeInfoDto;
import cn.com.duiba.activity.custom.center.api.params.cebbank.ExperienceCashIncomeInfoParam;
import cn.com.duiba.activity.custom.center.api.params.cebbank.ExperienceCashIncomeInfoUpdateParam;
import cn.com.duiba.activity.custom.center.api.params.cebbank.IncrementParam;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.Date;
import java.util.List;

@AdvancedFeignClient
public interface RemoteExperienceCashIncomeInfoService {

    /**
     * 保存
     *
     * @param experienceCashIncomeInfoEntity
     * @return
     */
    Long save(ExperienceCashIncomeInfoDto experienceCashIncomeInfoEntity);

    /**
     * 根据id修改
     *
     * @param experienceCashIncomeInfoEntity
     * @return
     */
    int updateById(ExperienceCashIncomeInfoUpdateParam experienceCashIncomeInfoEntity);

    /**
     * 根据利率增加利息
     * 1.接口支持重试，
     *
     * @return
     */
    int increamentByRate(IncrementParam param);

    /**
     * 获取利息
     *
     * @param id
     * @return
     */
    ExperienceCashIncomeInfoDto getById(Long id);

    ExperienceCashIncomeInfoDto getByBizNo(String bizNo);

    /**
     * 获取列表
     *
     * @param param
     * @return
     */
    List<ExperienceCashIncomeInfoDto> selectList(ExperienceCashIncomeInfoParam param);

    /**
     * 统计数据个数
     * 1.配合selectList使用
     *
     * @param param
     * @return
     */
    Long count(ExperienceCashIncomeInfoParam param);

    /**
     * selectList+count
     *
     * @param param
     * @return
     */
    PageResultDto<ExperienceCashIncomeInfoDto> page(ExperienceCashIncomeInfoParam param);


    /**
     * 统计用户已经获得的利息
     *
     * @param consumerId
     * @param activityId
     * @return
     */
    Long sumInterestAmount(Long consumerId, Long activityId);

    /**
     * 根据hcid和activiyId获取详情
     * 1.hcid和activityId 有唯一键，理论上只有一个
     *
     * @param helpConsumerId
     * @param activityId
     * @return
     */
    ExperienceCashIncomeInfoDto findOneByHelpConsumerIdAndActivityId(Long helpConsumerId, Long activityId);

    /**
     * 获取正在正在体验中的体验金
     *
     * @param interestOutTimeStart 利息时间 2019-05-29 00:00:00
     * @return
     */
    Long sumCashAmount(Long activityId, Long consumerId, Date interestOutTimeStart);

    /**
     * 定制任务接口，只允许在duiba-manager-web调用
     * 1.
     */
    void doTaskJob();

    /**
     * 青岛招行体验金提现结果定时任务
     *
     */
    void checkCashOutResult();
}
