package cn.com.duiba.activity.custom.center.api.remoteservice.hsbc;

import cn.com.duiba.activity.custom.center.api.dto.hsbc.HsbcAppItemTagDto;
import cn.com.duiba.activity.custom.center.api.params.hsbc.HsbcAppItemTagQueryParam;
import cn.com.duiba.biz.tool.duiba.dto.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author: pengyi
 * @description:
 * @date: 2023/4/19 11:17 AM
 */
@AdvancedFeignClient
public interface RemoteHsbcAppItemTagService {

    /**
     * 新增/编辑商品标签
     * @param hsbcAppItemTagDto
     * @return
     */
    boolean edit(HsbcAppItemTagDto hsbcAppItemTagDto);

    /**
     * 查询标签详情
     * @param id
     * @return
     */
    HsbcAppItemTagDto getById(Long id);

    /**
     * 分页列表
     * @param queryParam
     * @return
     */
    Page<HsbcAppItemTagDto> pageByParam(HsbcAppItemTagQueryParam queryParam);

    /**
     * 删除
     * @param id
     * @param appId
     * @return
     */
    boolean deleteById(Long id, Long appId);


    /**
     * 获得所有标签信息
     * @param appId
     * @return
     */
    List<HsbcAppItemTagDto> listAllByAppId(Long appId);


    /**
     * 标签唯一
     * @param appId
     * @param tagCode
     * @param id
     * @return
     */
    boolean tagCodeUnique(Long appId, String tagCode, Long id);
}
