package cn.com.duiba.activity.custom.center.api.enums.abcgoods;

import java.util.Objects;

/**
 * @author haojiahong
 * @date 2021-06-29
 */
public enum OwnStatusEnum {

    DELETED(0, "删除"),
    CREATED(1, "仓库中"),
    UP(2, "上架")

    ;

    private Integer status;
    private String desc;

    OwnStatusEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    public Integer getStatus() {
        return status;
    }

    public String getDesc() {
        return desc;
    }

    public static OwnStatusEnum getByStatus(Integer status) {
        for (OwnStatusEnum value : OwnStatusEnum.values()) {
            if (Objects.equals(value.getStatus(), status)) {
                return value;
            }
        }
        return null;
    }
}
