package cn.com.duiba.activity.custom.center.api.enums.citic;

import cn.com.duiba.boot.exception.BizException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * @Author: fss
 * @Date: 2022/8/29 11
 * @Description:
 */
public enum MonthTypeEnum {


    NEXT_MONTH(1, 1, "下个月"),
    CURRENT_MONTH(2, 0, "当月"),
    LAST_MONTH(3, -1, "上个月"),
    LAST_TWO_MONTH(4, -2, "上2个月"),
    LAST_THREE_MONTH(5, -3, "上3个月"),
    LAST_FOUR_MONTH(6, -4, "上4个月"),
    LAST_FIVE_MONTH(7, -5, "上5个月"),
    LAST_SIX_MONTH(8, -6, "上6个月"),
    LAST_SEVEN_MONTH(9, -7, "上7个月"),
    LAST_EIGHT_MONTH(10, -8, "上8个月"),
    LAST_NINE_MONTH(11, -9, "上9个月"),
    LAST_TEN_MONTH(12, -10, "上10个月"),
    LAST_ELEVEN_MONTH(13, -11, "上11个月"),
    LAST_TWELVE_MONTH(14, -12, "上12个月"),
    ;

    private Integer type;

    private Integer amount;

    private String desc;

    private static final Map<Integer, MonthTypeEnum> ENUM_MAP = new HashMap<>();
    private static final Logger LOGGER = LoggerFactory.getLogger(MonthTypeEnum.class);

    static {
        for (MonthTypeEnum tmp : values()) {
            ENUM_MAP.put(tmp.getType(), tmp);
        }
    }

    MonthTypeEnum(Integer type, Integer amount, String desc) {
        this.type = type;
        this.amount = amount;
        this.desc = desc;
    }

    public Integer getAmount() {
        return amount;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static int getBelongMonth(int monthType) throws BizException {
        SimpleDateFormat MONTH_NUMBER = new SimpleDateFormat("yyyyMM");
        MonthTypeEnum typeEnum = MonthTypeEnum.getByCode(monthType);
        if (typeEnum == null) {
            throw new BizException("未知月份类型");
        }
        int amount = typeEnum.getAmount();
        Date date = new Date();
        Calendar rightNow = Calendar.getInstance();
        rightNow.setTime(date);
        rightNow.add(Calendar.MONTH, amount);
        date = rightNow.getTime();

        Integer belongMonth = Integer.valueOf(MONTH_NUMBER.format(date));
        LOGGER.info("monthType:{},belongMonth:{},now:{}", monthType, belongMonth, System.currentTimeMillis());
        return belongMonth;
    }

    public static MonthTypeEnum getByCode(Integer code) {
        return ENUM_MAP.get(code);
    }
}
