package cn.com.duiba.activity.custom.center.api.enums.shuqi;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * Created by HePeng on 2019/08/15 10:16.
 */
public enum ShuqiConsumerPetStatusEnum {
    STATUS_CALL_ZONE(1, "召唤区"),
    STATUS_GAME_ZONE(2, "游戏区"),
    STATUS_USED(11, "已使用"),
    ;

    private int code;
    private String desc;

    private static Map<Integer, ShuqiConsumerPetStatusEnum> enumMap = Maps.newHashMap();
    static {
        enumMap.put(STATUS_CALL_ZONE.getCode(), STATUS_CALL_ZONE);
        enumMap.put(STATUS_GAME_ZONE.getCode(), STATUS_GAME_ZONE);
        enumMap.put(STATUS_USED.getCode(), STATUS_USED);
    }

    public static ShuqiConsumerPetStatusEnum getByCode(Integer code) {
        return enumMap.get(code);
    }

    ShuqiConsumerPetStatusEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
