package cn.com.duiba.activity.custom.center.api.remoteservice.abcgoods;

import cn.com.duiba.activity.custom.center.api.dto.abcgoods.AbcGoodsPageQueryDto;
import cn.com.duiba.activity.custom.center.api.dto.abcgoods.AbcGoodsStateLogDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author haojiahong
 * @date 2021-06-29
 */
@AdvancedFeignClient
public interface RemoteAbcGoodsStateLogService {

    /**
     * 新增or更新商品记录信息
     *
     * @param abcGoodsStateLogDto
     * @return
     */
    Boolean saveOrUpdate(AbcGoodsStateLogDto abcGoodsStateLogDto);

    /**
     * 根据id更新商品记录信息
     *
     * @param abcGoodsStateLogDto
     * @return
     */
    Boolean updateById(AbcGoodsStateLogDto abcGoodsStateLogDto);

    /**
     * 根据id查询记录集合
     *
     * @param ids
     * @return
     */
    List<AbcGoodsStateLogDto> listByIds(List<Long> ids);

    /**
     * 根据appItemId集合，批量跟新ownStatus状态
     *
     * @param appItemIdList
     * @param ownStatus
     * @return
     */
    Boolean batchUpdateOwnStatus(List<Long> appItemIdList, Integer ownStatus);

    /**
     * 根据appItemId查询商品记录信息
     *
     * @param appItemId
     * @return
     */
    List<AbcGoodsStateLogDto> getListByAppItemId(Long appItemId);

    /**
     * 根据活动编码查询商品记录信息
     *
     * @param actnCod
     * @return
     */
    AbcGoodsStateLogDto getByActnCod(String actnCod);

    /**
     * 分页查询
     *
     * @param abcGoodsPageQueryDto
     * @return
     */
    List<AbcGoodsStateLogDto> queryListPage(AbcGoodsPageQueryDto abcGoodsPageQueryDto);

    /**
     * 分页查询
     *
     * @param abcGoodsPageQueryDto
     * @return
     */
    Integer countListPage(AbcGoodsPageQueryDto abcGoodsPageQueryDto);

}
