package cn.com.duiba.activity.custom.center.api.remoteservice.zhaohang;

import cn.com.duiba.activity.custom.center.api.dto.zhaohang.ZhaohangAnswerConsumerDataDto;
import cn.com.duiba.activity.custom.center.api.params.zhaohang.BindRelationRequest;
import cn.com.duiba.activity.custom.center.api.params.zhaohang.SubmitScoreRequest;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * Created by HePeng on 2019/06/18 15:04.
 */
@AdvancedFeignClient
public interface RemoteZhaohangAnswerService {
    /**
     * 绑定好友关系
     * @param request
     * @throws BizException
     */
    void bindRelation(BindRelationRequest request) throws BizException;

    /**
     * 查询用户数据
     * @param consumerId
     * @return
     */
    ZhaohangAnswerConsumerDataDto getConsumerData(Long consumerId);

    /**
     * 提交分数
     * @param request
     * @throws BizException
     */
    void submitScore(SubmitScoreRequest request) throws BizException;

    /**
     * 查询用户的好友排行榜
     * @param consumerId
     * @param limit
     * @return
     */
    List<ZhaohangAnswerConsumerDataDto> getRankList(Long consumerId, Integer limit);
}
