package cn.com.duiba.activity.custom.center.api.remoteservice.book;


import cn.com.duiba.activity.custom.center.api.paramquery.PageQueryParam;
import cn.com.duiba.activity.custom.center.api.params.book.BookQueryParam;
import cn.com.duiba.activity.custom.center.api.remoteservice.book.dto.BookCategoryDto;
import cn.com.duiba.activity.custom.center.api.remoteservice.book.dto.BookChapterDto;
import cn.com.duiba.activity.custom.center.api.remoteservice.book.dto.BookDto;
import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * 小说服务
 */
@AdvancedFeignClient
public interface RemoteBookService {

    /**
     * 分页查询书籍列表
     */
    Page<BookDto> bookListPage(BookQueryParam bookQueryParam, PageQueryParam query);

    /**
     * 根据书籍id查询书籍信息
     */
    BookDto queryByBookId(Integer bookId);

    /**
     * 模糊搜索
     *
     * @param key
     * @return
     */
    List<BookDto> searchBookByKey(String key);

    /**
     * 根据书籍id批量查询(不包含书籍简介)
     */
    List<BookDto> queryByIds(List<Integer> bookIds);
    /**
     *@param  sortType 1降序 2升序
     * 根据书籍id分页查询章节列表
     */
    Page<BookChapterDto> bookChapterListPage(Integer bookId, Integer sortType, PageQueryParam query);


    /**
     *
     * @param bookId 书籍id
     * @param displayOrder 章节序号
     * @return
     */
    BookChapterDto queryByBookIdAndChapterOrder(Integer bookId, Integer displayOrder);

    /**
     * 根据书籍id查询当前最大章节信息
     * @param bookId
     * @return
     */
    BookChapterDto queryMaxBookChapter(Integer bookId);


    /**
     * 查询所有分类列表
     * @return
     */
    List<BookCategoryDto> queryAllBookCategoryList();

    /**
     * 根据分类id查询分类
     */
    BookCategoryDto queryByCategoryId(Integer categoryId);

    void saveBook() throws Exception;

    void saveCategory() throws Exception;


}
