package cn.com.duiba.activity.custom.center.api.paramquery;

import com.google.common.collect.Lists;

import java.io.Serializable;
import java.util.List;

/**
 * @Description page query result
 * @Author huliangsheng
 * @Date 2024/9/11 17:19
 */
public class PageResult<T> implements Serializable {

    private static final long serialVersionUID = 5033472050991731743L;

    /**
     * 页码
     */
    private Integer pageNo;

    /**
     * 查询条数
     */
    private Integer pageSize;

    /**
     * 数据总量
     */
    private Integer totalCount;

    /**
     * 数据
     */
    private List<T> list;

    public Integer getPageNo() {
        return pageNo;
    }

    public void setPageNo(Integer pageNo) {
        this.pageNo = pageNo;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getTotalCount() {
        return totalCount;
    }

    public void setTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
    }

    public List<T> getList() {
        return list;
    }

    public void setList(List<T> list) {
        this.list = list;
    }

    public static <T> PageResult<T> init(Integer pageIndex, Integer pageSize) {
        PageResult<T> pageResult = new PageResult<>();
        pageResult.setList(Lists.newArrayList());
        pageResult.setTotalCount(0);
        pageResult.setPageNo(pageIndex);
        pageResult.setPageSize(pageSize);
        return pageResult;
    }
}

