package cn.com.duiba.activity.custom.center.api.enums.activity;


import java.util.HashMap;
import java.util.Map;

/**
 * Created by fangdong on 2019/05/20
 */
public enum ActivityLogAccessTypeEnum {

    INDEX(1, "访问"),
    JOIN(2, "参加"),
    ;

    ActivityLogAccessTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    private static Map<Integer, ActivityLogAccessTypeEnum> typeEnumMap = new HashMap<>();

    static {
        for (ActivityLogAccessTypeEnum typeEnum : ActivityLogAccessTypeEnum.values()) {
            typeEnumMap.put(typeEnum.getType(), typeEnum);
        }
    }

    private Integer type;

    private String desc;

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static ActivityLogAccessTypeEnum getByType(Integer type) {
        return typeEnumMap.get(type);
    }

}
