package cn.com.duiba.activity.custom.center.api.dto.pinganshengqian;

import java.io.Serializable;
import java.util.Date;

/**
 * @Description 平安保险省钱小程序订单抵扣记录
 * @Author huliangsheng
 * @Date 2024/11/22 18:39
 */
public class PingAnShengQianDeductionDto implements Serializable {

    private static final long serialVersionUID = 2411966051983979503L;

    /**
     * 商品名称
     */
    public static final String EXTRA_ITEM_NAME = "itemName";

    /**
     * 商品图片
     */
    public static final String EXTRA_ITEM_IMAG = "itemImage";

    /**
     * 千猪备用金支付结果：成功、失败、异常
     */
    public static final String EXTRA_QIANZHU_PAY_RESULT = "qianzhu_pay_result";
    public static final String EXTRA_QIANZHU_PAY_RESULT_SUCCESS = "success";
    public static final String EXTRA_QIANZHU_PAY_RESULT_FAIL = "fail";
    public static final String EXTRA_QIANZHU_PAY_RESULT_EXCEPTION = "exception";

    /**
     * 主键
     */
    private Long id;

    /**
     * 应用id
     */
    private Long appId;

    /**
     * 用户id
     */
    private String uid;

    /**
     * 订单号
     */
    private String orderNum;

    /**
     * 支付单号
     */
    private String payOrderNum;

    /**
     * 抵扣金额（分）
     */
    private Long deduction;

    /**
     * 渠道（0-自有，1-三方）
     */
    private String channel;

    /**
     * 抵扣状态(success/fail)
     */
    private String status;

    /**
     * 商品描述
     */
    private String goodsInfo;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getOrderNum() {
        return orderNum;
    }

    public void setOrderNum(String orderNum) {
        this.orderNum = orderNum;
    }

    public String getPayOrderNum() {
        return payOrderNum;
    }

    public void setPayOrderNum(String payOrderNum) {
        this.payOrderNum = payOrderNum;
    }

    public Long getDeduction() {
        return deduction;
    }

    public void setDeduction(Long deduction) {
        this.deduction = deduction;
    }

    public String getChannel() {
        return channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getGoodsInfo() {
        return goodsInfo;
    }

    public void setGoodsInfo(String goodsInfo) {
        this.goodsInfo = goodsInfo;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}
