package cn.com.duiba.activity.custom.center.api.remoteservice.pinganshengqian;

import cn.com.duiba.activity.custom.center.api.dto.pinganshengqian.PingAnShengQianDeductionDto;
import cn.com.duiba.activity.custom.center.api.params.pinganshengqian.OrderRecordQueryParam;
import cn.com.duiba.activity.custom.center.api.params.pinganshengqian.PingAnOrderParam;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @Description 平安保险省钱小程序，订单记录remote
 * @Author huliangsheng
 * @Date 2024/11/22 15:29
 */
@AdvancedFeignClient
public interface RemotePingAnOrderService {

    /**
     * 新增一条订单记录
     */
    Boolean insertRecord(PingAnOrderParam param);

    /**
     * 修改订单记录
     */
    Boolean updateRecord(PingAnOrderParam param);

    /**
     * 查询订单记录列表
     */
    List<PingAnShengQianDeductionDto> pageQueryOrderListByType(OrderRecordQueryParam param);

    /**
     * 根据支付单号查询指定抵扣记录
     * @param payOrderNum 支付单号
     * @return 抵扣记录
     */
    PingAnShengQianDeductionDto queryByPayOrderNum(String payOrderNum);

}
