package cn.com.duiba.activity.custom.center.api.enums.qingdao;

import org.apache.commons.lang3.StringUtils;

/**
 * @Author: fss
 * @Date: 2021/12/1 16
 * @Description:
 */
public enum QdTaskTypeEnums {
    PERSONAL_TASK("personalTask", "个人资产任务"),
    BASIC_TASK("basicTask", "基础任务"),
    HIGH_TASK("highTask", "高级任务");

    private String code;
    private String desc;

    QdTaskTypeEnums(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static QdTaskTypeEnums enumsByType(String code) {
        if (StringUtils.isEmpty(code)) {
            return null;
        }
        for (QdTaskTypeEnums qdTaskTypeEnums : QdTaskTypeEnums.values()) {
            if (code.equals(qdTaskTypeEnums.getCode())) {
                return qdTaskTypeEnums;
            }
        }
        return null;
    }
}
