package cn.com.duiba.activity.custom.center.api.remoteservice.pinganshengqian;

import cn.com.duiba.activity.custom.center.api.dto.pinganshengqian.PingAnShengQianActCodeDto;
import cn.com.duiba.activity.custom.center.api.params.pinganshengqian.PingAnShengQianCodeParam;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @descriptions: 平安省钱小程序 激活码remote
 * @author: Wei Yi Ye
 * @date: 2024/11/20 18:13
 * @version: 1.0
 */
@AdvancedFeignClient
public interface RemotePingAnSqActCodeService {
    /**
     * 批量导入激活码
     *
     * @param codeList 激活码列表
     */
    Boolean generateActCode(List<PingAnShengQianCodeParam> codeList);

    /**
     * 批量查询激活码
     *
     * @param appId       appid
     * @param activeCodes 激活码列表
     * @return
     */
    List<PingAnShengQianActCodeDto> queryActCodeByCodes(Long appId, List<String> activeCodes);

    /**
     * 根据码查询
     *
     * @param appId      appId
     * @param activeCode 激活码
     */
    PingAnShengQianActCodeDto queryActCodeByCode(Long appId, String activeCode);

}
