package cn.com.duiba.activity.custom.center.api.enums.qingdao;

import org.apache.commons.lang3.StringUtils;

/**
 * @Author: fss
 * @Date: 2021/12/2 16
 * @Description:
 */
public enum HighTaskTypeEnums {
    FUND("fund", "每月购买基金"),
    DEPOSIT("deposit", "每月购买存款产品"),
    ONLINE_RISK("onlineRisk", "完成线上风险评估"),
    OTHER("other", "其他任务");

    private String code;
    private String desc;

    HighTaskTypeEnums(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static HighTaskTypeEnums enumsByType(String code) {
        if (StringUtils.isEmpty(code)) {
            return null;
        }
        for (HighTaskTypeEnums highTaskTypeEnums : HighTaskTypeEnums.values()) {
            if (code.equals(highTaskTypeEnums.getCode())) {
                return highTaskTypeEnums;
            }
        }
        return null;
    }
}
