package cn.com.duiba.activity.custom.center.api.enums.shuqi;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * Created by HePeng on 2019/08/15 10:17.
 */
public enum ShuqiConsumerPetSourceEnum {
    SOURCE_VISIT(1, "每日首次访问游戏"),
    SOURCE_SIGN(2, "每日签到"),
    SOURCE_READ(3, "阅读"),
    SOURCE_INVITE(4, "邀请"),
    SOURCE_MERGE(11, "合并"),
    ;

    private int code;
    private String desc;

    private static Map<Integer, ShuqiConsumerPetSourceEnum> enumMap = Maps.newHashMap();
    static {
        enumMap.put(SOURCE_VISIT.getCode(), SOURCE_VISIT);
        enumMap.put(SOURCE_SIGN.getCode(), SOURCE_SIGN);
        enumMap.put(SOURCE_READ.getCode(), SOURCE_READ);
        enumMap.put(SOURCE_INVITE.getCode(), SOURCE_INVITE);
        enumMap.put(SOURCE_MERGE.getCode(), SOURCE_MERGE);
    }

    public static ShuqiConsumerPetSourceEnum getByCode(Integer code) {
        return enumMap.get(code);
    }

    ShuqiConsumerPetSourceEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
