/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.rank.api.constants;

import cn.com.duiba.biz.tool.duiba.client.DateUtils;
import cn.com.duiba.rank.api.dto.rank.RankConfigDto;
import cn.com.duiba.rank.api.enums.RankCycleTypeEnum;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public class RankConfigConstants {
    public static final int RANK_LIMIT_NUM = 5000;
    private static final int DAILY_RANK_EXPIRE_DAYS = 3;
    private static final int WEEKLY_RANK_EXPIRE_DAYS = 14;
    private static final int MONTH_RANK_EXPIRE_DAYS = 45;
    private String rankId;
    private int expireDay;
    private Date openTime;

    public RankConfigConstants(RankConfigDto rank, Long separatorId) {
        String rankIdtmp = rank.getId().toString() + "_" + separatorId + "_";
        if (Objects.equals(rank.getRankCycle(), RankCycleTypeEnum.DAY.getCode())) {
            this.rankId = rankIdtmp + DateUtils.getDayStr((Date)new Date());
            this.expireDay = 3;
        } else if (Objects.equals(rank.getRankCycle(), RankCycleTypeEnum.WEEK.getCode())) {
            this.rankId = rankIdtmp + DateUtils.getWeekOfYear((Date)new Date());
            this.expireDay = 14;
        } else if (Objects.equals(rank.getRankCycle(), RankCycleTypeEnum.MONTH.getCode())) {
            this.rankId = rankIdtmp + DateUtils.getYYYYMM((Date)new Date());
            this.expireDay = 45;
        } else if (Objects.equals(rank.getRankCycle(), RankCycleTypeEnum.CUSTOM.getCode())) {
            if (!StringUtils.isBlank((String)rank.getRankCycleCustom())) {
                this.rankId = rankIdtmp + this.customRankMultiple(rank.getRankCycleCustom());
            }
        } else if (Objects.equals(rank.getRankCycle(), RankCycleTypeEnum.NONE.getCode())) {
            this.rankId = rankIdtmp + "0";
        }
    }

    public String getRankId() {
        return this.rankId;
    }

    public void setRankId(String rankId) {
        this.rankId = rankId;
    }

    public int getExpireDay() {
        return this.expireDay;
    }

    public void setExpireDay(int expireDay) {
        this.expireDay = expireDay;
    }

    public Date getOpenTime() {
        return this.openTime;
    }

    public void setOpenTime(Date openTime) {
        this.openTime = openTime;
    }

    private String customRankMultiple(String rankCycleCustom) {
        return null;
    }
}

