package cn.com.duiba.rank.api.dto.rank;

import java.io.Serializable;
import java.util.Date;

/**
 * ClassName:RankConfig 排行榜配置表<br/>
 *
 * @author gey
 * @version 1.0
 * @date 创建时间：2018/10/23  16:54
 * @since JDK 1.8
 **/
public class RankConfigDto implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 2022448654069892599L;
    //自增主键
    private Long id;
    //排行榜名称
    private String configName;
    //开启开关, false-没开 true-已开
    private Boolean configStatus;
    //是否开启分榜 true 开启活动分榜   false关闭分榜
    private Boolean configMultipleStatus;
    //榜单截止时间(多游戏)
    private Date endDate;
    //开奖截止时间(多游戏)
    private Date openPrizeTime;
    //限制类型0次/每天(多游戏)    1/永久
    private Integer limitScope;
    //限制次数(多游戏)
    private Integer limitTimes;
    //分数累计方式 false-单次最佳  true-累计(多游戏)
    private Boolean grandTotal;
    //统计周期 0无 1日榜 2周榜 3月榜 4自定义周期(多游戏)
    private Integer rankCycle;
    //自定义周期
    private String rankCycleCustom;
    //作弊名单
    private String cheatUser;
    //删除标识, 0-未删除 1-已删除
    private Boolean deleted = false;
    //是否发奖  true 发奖  false 不发奖
    private Boolean prizeOption;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getConfigName() {
        return configName;
    }

    public void setConfigName(String configName) {
        this.configName = configName;
    }

    public Boolean getConfigStatus() {
        return configStatus;
    }

    public void setConfigStatus(Boolean configStatus) {
        this.configStatus = configStatus;
    }

    public Boolean getConfigMultipleStatus() {
        return configMultipleStatus;
    }

    public void setConfigMultipleStatus(Boolean configMultipleStatus) {
        this.configMultipleStatus = configMultipleStatus;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Date getOpenPrizeTime() {
        return openPrizeTime;
    }

    public void setOpenPrizeTime(Date openPrizeTime) {
        this.openPrizeTime = openPrizeTime;
    }

    public Integer getLimitScope() {
        return limitScope;
    }

    public void setLimitScope(Integer limitScope) {
        this.limitScope = limitScope;
    }

    public Integer getLimitTimes() {
        return limitTimes;
    }

    public void setLimitTimes(Integer limitTimes) {
        this.limitTimes = limitTimes;
    }

    public Boolean getGrandTotal() {
        return grandTotal;
    }

    public void setGrandTotal(Boolean grandTotal) {
        this.grandTotal = grandTotal;
    }

    public Integer getRankCycle() {
        return rankCycle;
    }

    public void setRankCycle(Integer rankCycle) {
        this.rankCycle = rankCycle;
    }

    public String getRankCycleCustom() {
        return rankCycleCustom;
    }

    public void setRankCycleCustom(String rankCycleCustom) {
        this.rankCycleCustom = rankCycleCustom;
    }

    public String getCheatUser() {
        return cheatUser;
    }

    public void setCheatUser(String cheatUser) {
        this.cheatUser = cheatUser;
    }

    public Boolean getDeleted() {
        return deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public Boolean getPrizeOption() {
        return prizeOption;
    }

    public void setPrizeOption(Boolean prizeOption) {
        this.prizeOption = prizeOption;
    }
}