package cn.com.duiba.rank.api.remoteservice.rank;

import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.rank.api.dto.rank.RankingRecordDto;
import cn.com.duiba.rank.api.params.RankingRecordParam;

/**
 * @Description: 排行榜用户流水
 * @Author: fxr
 * @Date: 2019/1/16
 */
@AdvancedFeignClient
public interface RemoteRankingRecordBackedService {

    /**
     * 管理端检索排行榜名单列表
     *
     * @param param
     * @return
     */
    Page<RankingRecordDto> findRankingRecordList(RankingRecordParam param);

    /**
     * 查询排行榜名单
     *
     * @param rankMixId
     * @param consumerId
     * @return
     */
    RankingRecordDto findRankingRecord(String rankMixId, Long consumerId);
}