package cn.com.duiba.rank.api.remoteservice.rank;

import cn.com.duiba.api.bo.mq.ActivityRankScore;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.rank.api.dto.rank.ConsumerRankDto;
import cn.com.duiba.rank.api.params.RankingParam;

/**
 * @Description: 排行榜用户流水
 * @Author: fxr
 * @Date: 2019/1/16
 */
@AdvancedFeignClient
public interface RemoteRankingRecordService {
	/**
	 * 分页获取排名 包含用户自己的排行
	 *
	 * 1.按照分数降序,创建时间升序
	 * 2.手机端使用,比如获取前50名. pageNo=1,pageSize=50
	 * 3.pageSize最多100.暂定
	 *
	 * @return
	 */
	ConsumerRankDto listRankingRecord(RankingParam param);
	
	/**
	 * 压测 使用
	 *
	 * @return
	 */
	void addScore(ActivityRankScore params);
	
	/**
	 * 获取当前用户在排行榜中的名次及分数
	 *
	 * @return
	 */
	ConsumerRankDto getUserRanking(RankingParam param);
	
	/**
	 * 分页获取排名  不包含用户当前自己的排名
	 *
	 * 1.按照分数降序,创建时间升序
	 * 2.手机端使用,比如获取前50名. pageNo=1,pageSize=50
	 *
	 * @return
	 */
	ConsumerRankDto getRankingRecord(RankingParam param);
	
	/**
	 * 更新指定用户id
	 *
	 * @return
	 */
	Boolean updateRecode(String rankId,Long score,Long consumerId);
	
	/**
	 * 更新指定用户id
	 *
	 * @return
	 */
	Boolean deleteRecode(String rankId,Long consumerId);
}
