package cn.com.duiba.rank.api.remoteservice.rank;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.rank.api.dto.rank.RankingRelationDto;

@AdvancedFeignClient
public interface RemoteRankingRelationBackedService {

	/**
	 * @Description: 查询分榜信息
	 *
	 * @param rankId
	 *
	 * @author gey
	 *
	 * @date 2018/3/9 17:35
	 */
	public List<RankingRelationDto> findRankingRelationByRankId(Long rankId);

	/**
	 * @Description: 保存或者更新分榜信息
	 *
	 * @param list
	 * @param rankId
	 *
	 * @author gey
	 *
	 * @date 2018/3/9 17:35
	 */
	public Boolean saveOrUpdateRankingRelation(List<RankingRelationDto> list,Long rankId);
}