/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.rank.api.constants;

import cn.com.duiba.api.tools.DateUtils;
import cn.com.duiba.rank.api.dto.rank.RankConfigDto;
import cn.com.duiba.rank.api.enums.RankCycleTypeEnum;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;

public class RankConfigConstants {
    public static final int RANK_LIMIT_NUM = 5000;
    private static final int DAILY_RANK_EXPIRE_DAYS = 3;
    private static final int WEEKLY_RANK_EXPIRE_DAYS = 14;
    private static final int MONTH_RANK_EXPIRE_DAYS = 45;
    private String rankId;
    private int expireDay;
    private Date openTime;

    public RankConfigConstants(RankConfigDto rank, Long separatorId) {
        String rankIdtmp = rank.getId().toString() + "_" + separatorId + "_";
        if (Objects.equals(rank.getRankCycle(), RankCycleTypeEnum.DAY.getCode())) {
            this.rankId = rankIdtmp + DateUtils.getDayStr((Date)new Date());
            this.expireDay = 3;
            this.openTime = this.getNextDay(new Date());
        } else if (Objects.equals(rank.getRankCycle(), RankCycleTypeEnum.WEEK.getCode())) {
            this.rankId = rankIdtmp + DateUtils.getWeekOfYear((Date)new Date());
            this.expireDay = 14;
            this.openTime = RankConfigConstants.getNextWeekMonday(new Date());
        } else if (Objects.equals(rank.getRankCycle(), RankCycleTypeEnum.MONTH.getCode())) {
            this.rankId = rankIdtmp + DateUtils.getYYYYMM((Date)new Date());
            this.expireDay = 45;
            this.openTime = RankConfigConstants.getNextMonthFirstDay();
        } else if (Objects.equals(rank.getRankCycle(), RankCycleTypeEnum.NONE.getCode())) {
            this.rankId = rankIdtmp + "0";
            this.expireDay = RankConfigConstants.daysBetween(new Date(), rank.getOpenPrizeTime());
            this.openTime = rank.getOpenPrizeTime();
        }
    }

    public String getRankId() {
        return this.rankId;
    }

    public void setRankId(String rankId) {
        this.rankId = rankId;
    }

    public int getExpireDay() {
        return this.expireDay;
    }

    public void setExpireDay(int expireDay) {
        this.expireDay = expireDay;
    }

    public Date getOpenTime() {
        return this.openTime;
    }

    public void setOpenTime(Date openTime) {
        this.openTime = openTime;
    }

    public static int daysBetween(Date smdate, Date bdate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(smdate);
        long time1 = cal.getTimeInMillis();
        cal.setTime(bdate);
        long time2 = cal.getTimeInMillis();
        long betweenDays = (time2 - time1) / 86400000L;
        return Integer.parseInt(String.valueOf(betweenDays));
    }

    public static Date getNextMonthFirstDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(2, 1);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    private Date getNextDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, 1);
        return cal.getTime();
    }

    public static Date getNextWeekMonday(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(RankConfigConstants.getThisWeekMonday(date));
        cal.add(5, 7);
        return cal.getTime();
    }

    public static Date getThisWeekMonday(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayWeek = cal.get(7);
        if (1 == dayWeek) {
            cal.add(5, -1);
        }
        cal.setFirstDayOfWeek(2);
        int day = cal.get(7);
        cal.add(5, cal.getFirstDayOfWeek() - day);
        return cal.getTime();
    }
}

