package cn.com.duiba.rank.api.dto.rank;

import java.io.Serializable;

/**
 * @Description: 排行榜开奖记录表
 * @Author: fxr
 * @Date: 2019/1/21
 */
public class RankOpenPrizeRecordDto implements Serializable {

    private static final long serialVersionUID = 4458325763385616558L;

    /**
     * 发奖成功
     */
    public static final int OPENSUCCESS = 1;

    /**
     * 发奖失败
     */
    public static final int OPENFAIL = 0;

    /**
     * 主键
     * 自增主键
     * isNullAble:0
     */
    private Long id;

    /**
     * 排行榜id_赛季信息_分榜id
     * isNullAble:0
     */
    private String rankMixId;

    /**
     * 用户id
     * isNullAble:0
     */
    private Long consumerId;

    /**
     * 领奖名次
     * isNullAble:0
     */
    private String award;

    /**
     * 奖项id
     * isNullAble:0
     */
    private Long prizeId;

    /**
     * 奖项类型
     * isNullAble:0
     */
    private String prizeType;

    /**
     * 奖项名称
     * isNullAble:0
     */
    private String prizeName;

    /**
     * 面额
     * isNullAble:0
     */
    private String facePrice;

    /**
     * 兑吧兑换项ID
     * isNullAble:1
     */
    private Long itemId;

    /**
     * 开发者兑换项ID
     * isNullAble:1
     */
    private Long appItemId;

    /**
     * 发奖状态：0：发放失败 1：发放成功
     * isNullAble:0,defaultVal:0
     */
    private Integer status;

    /**
     * 开奖失败时错误描述信息
     * isNullAble:1
     */
    private String message;

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public void setRankMixId(String rankMixId) {
        this.rankMixId = rankMixId;
    }

    public String getRankMixId() {
        return this.rankMixId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Long getConsumerId() {
        return this.consumerId;
    }

    public void setAward(String award) {
        this.award = award;
    }

    public String getAward() {
        return this.award;
    }

    public void setPrizeId(Long prizeId) {
        this.prizeId = prizeId;
    }

    public Long getPrizeId() {
        return this.prizeId;
    }

    public void setPrizeType(String prizeType) {
        this.prizeType = prizeType;
    }

    public String getPrizeType() {
        return this.prizeType;
    }

    public void setPrizeName(String prizeName) {
        this.prizeName = prizeName;
    }

    public String getPrizeName() {
        return this.prizeName;
    }

    public void setFacePrice(String facePrice) {
        this.facePrice = facePrice;
    }

    public String getFacePrice() {
        return this.facePrice;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getItemId() {
        return this.itemId;
    }

    public void setAppItemId(Long appItemId) {
        this.appItemId = appItemId;
    }

    public Long getAppItemId() {
        return this.appItemId;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }
}