package cn.com.duiba.rank.api.dto.rank;

import java.io.Serializable;
import java.util.Date;

/**
 * @Description: 排行榜用户流水
 * @Author: fxr
 * @Date: 2019/1/16
 */
public class RankingRecordDto implements Serializable {

    private static final long serialVersionUID = 8758759308657656657L;

    /**
     * 被标记作弊
     */
    public static final int ISCHEAT = 1;

    /**
     * 未被标记作弊
     */
    public static final int NOTCHEAT = 0;


    /**
     * 自增主键
     */
    private Long id;

    /**
     * 排行榜id_赛季信息_分榜id
     */
    private String rankMixId;

    /**
     * appId
     */
    private Long appId;

    /**
     * 用户id
     */
    private Long consumerId;

    /**
     * 分数
     */
    private Long score;

    /**
     * 是否标记作弊 0否 1是
     */
    private Integer cheat;

    /**
     * 订单号
     */
    private String orderNum;

    /**
     * 开奖时的排名
     */
    private Integer rank;

    /**
     * 活动id
     */
    private Long activityId;
    /**
     * 活动类型
     *
     * @see cn.com.duiba.api.enums.RankActivityTypeEnum
     */
    private Integer activityTpye;

    private Date gmtModified;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getRankMixId() {
        return rankMixId;
    }

    public void setRankMixId(String rankMixId) {
        this.rankMixId = rankMixId;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Long getScore() {
        return score;
    }

    public void setScore(Long score) {
        this.score = score;
    }

    public Integer getCheat() {
        return cheat;
    }

    public void setCheat(Integer cheat) {
        this.cheat = cheat;
    }

    public String getOrderNum() {
        return orderNum;
    }

    public void setOrderNum(String orderNum) {
        this.orderNum = orderNum;
    }

    public Integer getRank() {
        return rank;
    }

    public void setRank(Integer rank) {
        this.rank = rank;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public Integer getActivityTpye() {
        return activityTpye;
    }

    public void setActivityTpye(Integer activityTpye) {
        this.activityTpye = activityTpye;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}