package cn.com.duiba.rank.api.enums;

import java.util.List;

import com.google.common.collect.Lists;

//统计周期 0无 1日榜 2周榜 3月榜 4自定义周期(多游戏)
public enum RankCycleTypeEnum {

	NONE(0,"无周期"),
	DAY(1,"日榜"),
	WEEK(2,"周榜"),
	MONTH(3,"月榜"),
	CUSTOM(4,"自定义周期"),;

	//后续操作key
	private Integer code;
	//名称
	private String name;

	private static List<RankCycleTypeEnum> list = Lists.newArrayList();

	RankCycleTypeEnum(Integer code,String name){
		this.name = name;
		this.code = code;
	}

	public Integer getCode() {
		return code;
	}

	public String getName() {
		return name;
	}

	static{
		for(RankCycleTypeEnum typeClass : RankCycleTypeEnum.values()){
			list.add(typeClass);
		}
	}

	/**
	 * 获取全部 枚举值和名称
	 * @return
	 */
	public static List<RankCycleTypeEnum> getAll(){
		return list;
	}
}