package cn.com.duiba.rank.api.params;


import cn.com.duiba.api.bo.page.PageQuery;

import java.io.Serializable;

/**
 * @Description: 排行榜名单查询参数
 * @Author: gey
 * @Date: 2019/1/16
 */
public class RankingParam extends PageQuery implements Serializable {

	private static final long serialVersionUID = -4110830425217387151L;

	/**
	 * 排行榜id
	 */
	private Long rankId;

	/**
	 * appId
	 */
	private Long appId;

	/**
	 * consumerId
	 */
	private Long consumerId;

	/**
	 * 活动工具
	 * @see cn.com.duiba.api.enums.RankActivityTypeEnum
	 */
	private Integer activityTpye;
	/**
	 * 兑吧id
	 */
	private Long duibaId;
	/**
	 * 入库id
	 */
	private Long opId;

	/**
	 * 是否获取上期排行榜数据
	 */
	private Boolean isPreviousPeriod = false;

	public Long getAppId() {
		return appId;
	}

	public void setAppId(Long appId) {
		this.appId = appId;
	}

	public Long getConsumerId() {
		return consumerId;
	}

	public void setConsumerId(Long consumerId) {
		this.consumerId = consumerId;
	}

	public Long getRankId() {
		return rankId;
	}

	public void setRankId(Long rankId) {
		this.rankId = rankId;
	}

	public Integer getActivityTpye() {
		return activityTpye;
	}

	public void setActivityTpye(Integer activityTpye) {
		this.activityTpye = activityTpye;
	}

	public Long getDuibaId() {
		return duibaId;
	}

	public void setDuibaId(Long duibaId) {
		this.duibaId = duibaId;
	}

	public Boolean getPreviousPeriod() {
		return isPreviousPeriod;
	}

	public void setPreviousPeriod(Boolean previousPeriod) {
		isPreviousPeriod = previousPeriod;
	}

	public Long getOpId() {
		return opId;
	}

	public void setOpId(Long opId) {
		this.opId = opId;
	}
}