package cn.com.duiba.rank.api.dto.rank;

import java.io.Serializable;
import java.util.Date;

/**
 * ClassName:RankingRelation 排行榜配置表<br/>
 *
 * @author gey
 * @version 1.0
 * @date 创建时间：2018/10/23 16:54
 * @since JDK 1.8
 **/
public class RankingScanDto implements Serializable {

	/**
	 *
	 */
	private static final long serialVersionUID = 6865027775061778817L;

	/**
	 * 未开奖
	 */
	public static final int UNOPEN = 0;

	/**
	 * 开奖中
	 */
	public static final int OPENING = 1;

	/**
	 * 开奖失败
	 */
	public static final int OPENFAIL = 2;

	/**
	 * 开奖成功
	 */
	public static final int OPENSUCCESS = 3;

	// 自增主键
	private Long id;
	// appId
	private Long appId;
	// 排行榜id_赛季信息_分榜id
	private String rankMixId;
	// 0:未开奖 1已开奖中 2开奖失败
	private Integer openPrizeStatus;
	// 开奖失败时 错误信息
	private String openPrizeMsg;
	// 开奖时间(yyyy-mm-dd)
	private Date openPrizeTime;
	// 排行榜 统计开始时间
	private Date startTime;
	// 排行榜 统计结束时间
	private Date endTime;
	// 自动开奖, false-手动 true-自动
	private Boolean automaticPrizeStatus;
	// 是否采用新 开奖地址 true 新地址 false 旧地址
	private Boolean prizeNewFalg;
	//是否发奖  true 发奖  false 不发奖
	private Boolean prizeOption;
	//rankId
	private Long rankId;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getRankMixId() {
		return rankMixId;
	}

	public void setRankMixId(String rankMixId) {
		this.rankMixId = rankMixId;
	}

	public Integer getOpenPrizeStatus() {
		return openPrizeStatus;
	}

	public void setOpenPrizeStatus(Integer openPrizeStatus) {
		this.openPrizeStatus = openPrizeStatus;
	}

	public String getOpenPrizeMsg() {
		return openPrizeMsg;
	}

	public void setOpenPrizeMsg(String openPrizeMsg) {
		this.openPrizeMsg = openPrizeMsg;
	}

	public Date getOpenPrizeTime() {
		return openPrizeTime;
	}

	public void setOpenPrizeTime(Date openPrizeTime) {
		this.openPrizeTime = openPrizeTime;
	}

	public Boolean getAutomaticPrizeStatus() {
		return automaticPrizeStatus;
	}

	public void setAutomaticPrizeStatus(Boolean automaticPrizeStatus) {
		this.automaticPrizeStatus = automaticPrizeStatus;
	}

	public Boolean getPrizeNewFalg() {
		return prizeNewFalg;
	}

	public void setPrizeNewFalg(Boolean prizeNewFalg) {
		this.prizeNewFalg = prizeNewFalg;
	}

	public Date getStartTime() {
		return startTime;
	}

	public void setStartTime(Date startTime) {
		this.startTime = startTime;
	}

	public Date getEndTime() {
		return endTime;
	}

	public void setEndTime(Date endTime) {
		this.endTime = endTime;
	}

	public Boolean getPrizeOption() {
		return prizeOption;
	}

	public void setPrizeOption(Boolean prizeOption) {
		this.prizeOption = prizeOption;
	}
	public Long getAppId() {
		return appId;
	}
	public void setAppId(Long appId) {
		this.appId = appId;
	}

	public Long getRankId() {
		return rankId;
	}

	public void setRankId(Long rankId) {
		this.rankId = rankId;
	}
}