package cn.com.duiba.rank.api.enums;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;

import java.util.Map;

/**
 * 全局类型 定义了外投类型
 */
public enum RankGlobalCodeEnum {

    MULTIPLE_SINGLE_BEST_NONE(1, RankTypeEnum.MULTIPLE, RankGrandTypeEnum.SINGLE_BEST, RankCycleTypeEnum.NONE),
    MULTIPLE_SINGLE_BEST_DAY(2, RankTypeEnum.MULTIPLE, RankGrandTypeEnum.SINGLE_BEST, RankCycleTypeEnum.DAY),
    MULTIPLE_SINGLE_BEST_WEEK(3, RankTypeEnum.MULTIPLE, RankGrandTypeEnum.SINGLE_BEST, RankCycleTypeEnum.WEEK),
    MULTIPLE_SINGLE_BEST_MONTH(4, RankTypeEnum.MULTIPLE, RankGrandTypeEnum.SINGLE_BEST, RankCycleTypeEnum.MONTH),
    MULTIPLE_SINGLE_BEST_CUSTOM(5, RankTypeEnum.MULTIPLE, RankGrandTypeEnum.SINGLE_BEST, RankCycleTypeEnum.CUSTOM),

    MULTIPLE_TOTAL_NONE(6, RankTypeEnum.MULTIPLE, RankGrandTypeEnum.TOTAL, RankCycleTypeEnum.NONE),
    MULTIPLE_TOTAL_DAY(7, RankTypeEnum.MULTIPLE, RankGrandTypeEnum.TOTAL, RankCycleTypeEnum.DAY),
    MULTIPLE_TOTAL_WEEK(8, RankTypeEnum.MULTIPLE, RankGrandTypeEnum.TOTAL, RankCycleTypeEnum.WEEK),
    MULTIPLE_TOTAL_MONTH(9, RankTypeEnum.MULTIPLE, RankGrandTypeEnum.TOTAL, RankCycleTypeEnum.MONTH),
    MULTIPLE_TOTAL_CUSTOM(10, RankTypeEnum.MULTIPLE, RankGrandTypeEnum.TOTAL, RankCycleTypeEnum.CUSTOM),

    MULTIPLE_TOTAL_DAY_NONE(11, RankTypeEnum.MULTIPLE, RankGrandTypeEnum.TOTAL_DAY, RankCycleTypeEnum.NONE),
    MULTIPLE_TOTAL_DAY_DAY(12, RankTypeEnum.MULTIPLE, RankGrandTypeEnum.TOTAL_DAY, RankCycleTypeEnum.DAY),
    MULTIPLE_TOTAL_DAY_WEEK(13, RankTypeEnum.MULTIPLE, RankGrandTypeEnum.TOTAL_DAY, RankCycleTypeEnum.WEEK),
    MULTIPLE_TOTAL_DAY_MONTH(14, RankTypeEnum.MULTIPLE, RankGrandTypeEnum.TOTAL_DAY, RankCycleTypeEnum.MONTH),
    MULTIPLE_TOTAL_DAY_CUSTOM(15, RankTypeEnum.MULTIPLE, RankGrandTypeEnum.TOTAL_DAY, RankCycleTypeEnum.CUSTOM),

    SINGLE_TOTAL_NONE(16, RankTypeEnum.SINGLE, RankGrandTypeEnum.TOTAL, RankCycleTypeEnum.NONE),
    SINGLE_TOTAL_DAY(17, RankTypeEnum.SINGLE, RankGrandTypeEnum.TOTAL, RankCycleTypeEnum.DAY),
    SINGLE_TOTAL_WEEK(18, RankTypeEnum.SINGLE, RankGrandTypeEnum.TOTAL, RankCycleTypeEnum.WEEK),
    SINGLE_TOTAL_MONTH(19, RankTypeEnum.SINGLE, RankGrandTypeEnum.TOTAL, RankCycleTypeEnum.MONTH),
    SINGLE_TOTAL_CUSTOM(20, RankTypeEnum.SINGLE, RankGrandTypeEnum.TOTAL, RankCycleTypeEnum.CUSTOM),

    SINGLE_SINGLE_BEST_NONE(21, RankTypeEnum.SINGLE, RankGrandTypeEnum.SINGLE_BEST, RankCycleTypeEnum.NONE),
    SINGLE_SINGLE_BEST_DAY(22, RankTypeEnum.SINGLE, RankGrandTypeEnum.SINGLE_BEST, RankCycleTypeEnum.DAY),
    SINGLE_SINGLE_BEST_WEEK(23, RankTypeEnum.SINGLE, RankGrandTypeEnum.SINGLE_BEST, RankCycleTypeEnum.WEEK),
    SINGLE_SINGLE_BEST_MONTH(24, RankTypeEnum.SINGLE, RankGrandTypeEnum.SINGLE_BEST, RankCycleTypeEnum.MONTH),
    SINGLE_SINGLE_BEST_CUSTOM(25, RankTypeEnum.SINGLE, RankGrandTypeEnum.SINGLE_BEST, RankCycleTypeEnum.CUSTOM),

    ;

    private Integer code;

    private RankTypeEnum rankType;

    private RankGrandTypeEnum rankGrandType;

    private RankCycleTypeEnum rankCycleType;

    private static final ImmutableMap<String, Integer> MAPPING;

    static {
        Map<String, Integer> temp = Maps.newHashMap();
        for (RankGlobalCodeEnum type : values()) {
            String key = type.rankType + "_" + type.rankGrandType + "_" + type.rankCycleType;
            temp.put(key, type.code);
        }
        MAPPING = ImmutableMap.copyOf(temp);
    }

    RankGlobalCodeEnum(int code, RankTypeEnum rankType, RankGrandTypeEnum rankGrandType, RankCycleTypeEnum rankCycleType) {
        this.code = code;
        this.rankType = rankType;
        this.rankGrandType = rankGrandType;
        this.rankCycleType = rankCycleType;
    }

    /**
     * 查询排行榜的全局编号
     * @param rankType
     * @param rankGrandType
     * @param rankCycleType
     * @return
     */
    public static Integer getGlobalCode(Integer rankType, Integer rankGrandType, Integer rankCycleType) {
        String key = rankType + "_" + rankGrandType + "_" + rankCycleType;
        return MAPPING.get(key);
    }

}
