package cn.com.duiba.rank.api.enums;

import java.util.List;

import com.google.common.collect.Lists;

public enum RankGrandTypeEnum {


	SINGLE_BEST(0,"单次最佳"),
	TOTAL(1,"累计（总累计）"),
	TOTAL_DAY(2,"累计（日最佳）"),;

	//后续操作key
	private Integer code;
	//名称
	private String name;
	
	private static List<RankGrandTypeEnum> list = Lists.newArrayList();

	RankGrandTypeEnum(Integer code,String name){
		this.name = name;
		this.code = code;
	}

	public Integer getCode() {
		return code;
	}

	public String getName() {
		return name;
	}
	
	static{
		for(RankGrandTypeEnum typeClass : RankGrandTypeEnum.values()){
			list.add(typeClass);
		}
	}

	/**
	 * 获取全部 枚举值和名称
	 * @return
	 */
	public static List<RankGrandTypeEnum> getAll(){
		return list;
	}
}
