package cn.com.duiba.rank.api.remoteservice.rank;

import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.rank.api.dto.rank.RankConfigDto;
import cn.com.duiba.rank.api.params.RankParam;
import cn.com.duiba.rank.api.params.RankSingleParam;

import java.util.List;

@AdvancedFeignClient
public interface RemoteRankConfigBackedService {
	
    /**
     * @param param
     * @Description: 根据条件查询排行榜配置信息
     * @author gey
     * @date 2018/3/9 17:35
     */
    public List<RankConfigDto> findAllRank(String configName);

    /**
     * @param param
     * @Description: 根据条件查询排行榜配置信息
     * @author gey
     * @date 2018/3/9 17:35
     */
    public Page<RankConfigDto> findRankList(RankParam param);

    /**
     * @param rankConfigDto
     * @Description: 保存或者更新排行榜配置信息
     * @author gey
     * @date 2018/3/9 17:35
     */
    public Long saveOrUpdateRankConfig(RankConfigDto rankConfigDto);

    /**
     * @param id
     * @Description: 根据条件id查询 排行榜配置信息
     * @author gey
     * @date 2018/3/9 17:35
     */
    public RankConfigDto findRankById(Long id);

    /**
     * 根据条件id删除 排行榜配置信息
     *
     * @param id
     * @return
     */
    int deleteRankConfById(Long id);

    int switchByConfigId(Long id, Boolean configStatus);

    /**
     * 查询所有未绑定的带游戏排行榜
     */
    List<RankConfigDto> findAllUnBindingSingleRanking(RankSingleParam param);
}