package cn.com.duiba.rank.api.remoteservice.rank;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.rank.api.dto.rank.RankOpenPrizeRecordDto;
import cn.com.duiba.rank.api.dto.rank.RankingScanDto;

@AdvancedFeignClient
public interface RemoteRankOpenPrizeRecordService {
    /**
     * @param rankMixId
     * @Description: 开奖信息
     * @author gey
     * @date 2019/1/22 17:35
     */
    public RankingScanDto findRankMixId(String rankMixId);

    /**
     * @param rankMixId
     * @Description: 根据consumerId 和rankId 查询 排行榜开奖情况
     * @author gey
     * @date 2019/1/22 17:35
     */
    RankOpenPrizeRecordDto findByRankIdAndConsumerId(Long consumerId, String rankId);

    /**
     * 插入开奖记录
     *
     * @param dto
     * @return
     */
    Integer inserOpernPrizeRecord(RankOpenPrizeRecordDto dto);


    /**
     * 更新订单状态
     *
     * @param dto
     * @return
     */
    Integer updateStatusInfo(String rankMixId,Long consumerId,Integer status,String message);
}