package cn.com.duiba.rank.api.remoteservice.rank;

import cn.com.duiba.api.bo.mq.ActivityRankScore;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.rank.api.dto.rank.ConsumerRankDto;
import cn.com.duiba.rank.api.dto.rank.RankInfoDto;
import cn.com.duiba.rank.api.dto.rank.RankOpenPrizeRecordDto;
import cn.com.duiba.rank.api.dto.rank.RankingRelationSimpleDto;
import cn.com.duiba.rank.api.params.RankingParam;

import java.util.List;

/**
 * @Description: 排行榜用户流水  新版
 * @Author: gey
 * @Date: 2019/6/16
 */
@AdvancedFeignClient
public interface RemoteRankService {
	
	/**
	 * 查询 活动 绑定 排行榜关系
	 *
	 * @param activityId
	 * @param activityTpye
	 *
	 * @return
	 */
	List<RankingRelationSimpleDto> findRankInfo(Long activityId,Integer activityTpye);
	
	/**
	 * 查询 排行榜 配置奖品 信息
	 *
	 * @param rankId
	 *
	 * @return
	 */
	RankInfoDto findRankConfigOptionByRankId(Long rankId,Long opId,Long appId, Boolean needPreviousPeriod);
	
	/**
	 * 分页获取本期/上期排名  不包含用户当前自己的排名
	 *
	 * 1.按照分数降序,创建时间升序
	 * 2.手机端使用,比如获取前50名. pageNo=1,pageSize=50
	 *
	 * @return
	 */
	ConsumerRankDto getRankingRecordNew(RankingParam param);
	
	/**
	 * 获取当前用户在本期/上期排行榜中的名次及分数
	 *
	 * @return
	 */
	ConsumerRankDto getUserRankingNew(RankingParam param);

	/**
	 * 获取当前用户在本期  最高成绩
	 *
	 * @return
	 */
	Long getUserRankMaxScore(RankingParam param);
	
	
	/**
	 * 豪客来  定制接口
	 *
	 * @return
	 */
	Boolean addScore(ActivityRankScore params);
	
	
	/**
	 * 查询排行榜 开奖信息
	 *
	 * @return
	 */
	RankOpenPrizeRecordDto getOpenPrizeRecordInfo(Long rankId,Long opId,Long appId,Long consumerId);
}