package cn.com.duiba.rank.api.remoteservice.rank;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.rank.api.dto.rank.RankingRelationDto;
import cn.com.duiba.rank.api.dto.rank.RankingRelationInfoDto;

import java.util.List;

@AdvancedFeignClient
public interface RemoteRankingRelationBackedService {

	/**
	 * @Description: 排行榜关联配置
	 *
	 * @param rankId
	 *
	 * @author gey
	 *
	 * @date 2018/3/9 17:35
	 */
	public List<RankingRelationDto> findRankingRelationByRankId(Long rankId);

	/**
	 * @Description: 保存或者更新排行榜关联配置
	 *
	 * @param list
	 * @param rankId
	 *
	 * @author gey
	 *
	 * @date 2018/3/9 17:35
	 */
	public Boolean saveOrUpdateRankingRelation(List<RankingRelationDto> list,Long rankId);
	
	/**
	 * @Description: 保存或者更新排行榜关联配置
	 *
	 * @param list
	 *
	 * @author gey
	 *
	 * @date 2018/3/9 17:35
	 */
	public List<RankingRelationInfoDto> findRankingRelationByRankIds(List<Long> list);


	/**
	 * 增加单活动排行榜绑定关系
	 *
	 * 会清除和oldRankId排行榜的关联关系
	 * 会绑定rankId排行榜
	 *
	 * 1.排行榜已经被当前活动绑定，返回当前关系
	 * 2.排行榜已经被其他活动绑定，返回null
	 * 3.排行榜未被其他活动绑定，当前活动未绑定其他排行榜，新增绑定关系，并返回当前关系
	 * 4.排行榜未被其他活动绑定，当前活动绑定了其他排行榜，删除旧关系，新增新关系，并返回当前关系
	 */
	RankingRelationDto upsetSingleRelation(Integer activityType, Long activityId, Long rankId, Long oldRankId);

}