package cn.com.duiba.rank.api.remoteservice.rank;

import java.util.List;

import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.rank.api.dto.rank.RankingScanDto;
import cn.com.duiba.rank.api.params.RankingScanParam;

@AdvancedFeignClient
public interface RemoteRankingScanBackedService {

	/**
	 * @Description: 开奖信息
	 *
	 * @param rankMixId
	 *
	 * @author gey
	 *
	 * @date 2019/1/22 17:35
	 */
	public RankingScanDto findRankMixId(String rankMixId);

	/**
	 * @Description: 查询rankId 下 所有分榜信息
	 *
	 * @param rankId
	 *
	 * @author gey
	 *
	 * @date 2019/1/22 17:35
	 */
	public List<RankingScanDto> findAllByRankId(Long rankId);

	Boolean updateScanInfo(RankingScanDto rankingScanDto);

	/**
	 * 管理端检索排行榜名单列表
	 *
	 * @param param
	 * @return
	 */
	Page<RankingScanDto> findRankingScanList(RankingScanParam param);
	
	/**
	 *  定时任务 扫描使用
	 *
	 * @param param
	 * @return
	 */
	List<RankingScanDto> findRankingScan();

}